{ ------------------------------------------------------------------------ }
{  @@ Source Documentation                           *** TP6 Version ***   }
{                                                                          }
{  Copyright (c) Creative Technology Pte Ltd, 1991. All rights reserved.   }
{                                                                          }
{   TITLE       : MIDIOUT.PAS                                              }
{                                                                          }
{   DESCRIPTION :                                                          }
{       This program demostrates how to use the SBK MIDI interface         }
{       functions to play a 'C major scale'. It calls the MIDI low         }
{       level interface functions to send the MIDI commands to MIDI        }
{       keyboard.                                                          }
{                                                                          }
{       The program checks BLASTER environment for the Card settings.      }
{       It also performs test base on BLASTER environment settings to      }
{       ensure they are tally with the hardware settings on the Card.      }
{                                                                          }
{ ------------------------------------------------------------------------ }

program midiout;

{ Include the SBC Unit, and any other units needed }
uses sbc_tp6, dos, crt;

const
    { look up table for a scale starting from 'Middle C' }
    note_num : array[0..7] of byte = ( 60,62,64,65,67,69,71,72 );


{ ------------------------------------------------------------------------ }

{ main function }
var
    i, j, note, dummy : word;
    pnum : byte;


begin

    if GetEnvSetting = 0 then begin

        if boolean( sbc_check_card and $0004 ) then begin

            for pnum := 0 to 4 do begin

                { program change command }
                dummy := sbmidi_out_shortmsg( $C0, pnum, 0 );

                { play the Middle C scale }
                for note := 0 to 7 do begin

                    { Note On command }
                    dummy := sbmidi_out_shortmsg( $90, note_num[note], $40 );

                    { delay loop }
                    for i := 0 to 150 do
                        for j := 0 to 1000 do begin
                        end;

                    { Note Off command }
                    dummy := sbmidi_out_shortmsg( $80, note_num[note], $40 );

                end;

            end;

        end
        else
            writeln('Sound Blaster card not found or wrong I/O setting.');
    end
    else
        writeln('BLASTER environment variable not set or incomplete or invalid.');

end.
